<?php
require_once 'config.php';
requireDepartment(['admin']);

// Get filter parameters
$type = isset($_GET['type']) ? $_GET['type'] : 'excel';
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');
$department = isset($_GET['department']) ? $_GET['department'] : 'all';

// Prepare SQL conditions
$date_condition = "DATE(c.created_at) BETWEEN '$start_date' AND '$end_date'";
$dept_condition = $department != 'all' ? "c.current_department = '$department'" : "1=1";

// Get data for export
$clients = $conn->query("
    SELECT 
        c.id,
        c.name,
        c.phone,
        c.package,
        c.country,
        c.current_department,
        c.status,
        c.payment_status,
        DATE(c.created_at) as created_date,
        u.full_name as assigned_to
    FROM clients c
    LEFT JOIN users u ON c.assigned_to = u.id
    WHERE $date_condition AND $dept_condition
    ORDER BY c.created_at DESC
");

if ($type == 'excel') {
    // Excel export
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="client_report_' . date('Y-m-d') . '.xls"');
    
    echo '<table border="1">';
    echo '<tr><th colspan="9" style="background:#667eea;color:white;padding:10px;">Client Management System - Report</th></tr>';
    echo '<tr><th colspan="9">Period: ' . $start_date . ' to ' . $end_date . '</th></tr>';
    echo '<tr><th colspan="9">Generated: ' . date('Y-m-d H:i:s') . '</th></tr>';
    echo '<tr>';
    echo '<th>ID</th>';
    echo '<th>Name</th>';
    echo '<th>Phone</th>';
    echo '<th>Package</th>';
    echo '<th>Country</th>';
    echo '<th>Department</th>';
    echo '<th>Status</th>';
    echo '<th>Payment</th>';
    echo '<th>Created Date</th>';
    echo '</tr>';
    
    while($client = $clients->fetch_assoc()) {
        echo '<tr>';
        echo '<td>' . $client['id'] . '</td>';
        echo '<td>' . htmlspecialchars($client['name']) . '</td>';
        echo '<td>' . htmlspecialchars($client['phone']) . '</td>';
        echo '<td>' . $client['package'] . '</td>';
        echo '<td>' . htmlspecialchars($client['country']) . '</td>';
        echo '<td>' . $client['current_department'] . '</td>';
        echo '<td>' . $client['status'] . '</td>';
        echo '<td>' . $client['payment_status'] . '</td>';
        echo '<td>' . $client['created_date'] . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
} elseif ($type == 'pdf') {
    // PDF export - You'll need a PDF library like TCPDF or Dompdf
    // This is a basic implementation
    
    require_once 'tcpdf/tcpdf.php'; // You need to install TCPDF
    
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    $pdf->SetCreator('Client Management System');
    $pdf->SetAuthor('Admin');
    $pdf->SetTitle('Client Report');
    $pdf->SetSubject('Client Management Report');
    
    $pdf->AddPage();
    
    // Add content
    $html = '
    <h1>Client Management System - Report</h1>
    <p><strong>Period:</strong> ' . $start_date . ' to ' . $end_date . '</p>
    <p><strong>Generated:</strong> ' . date('Y-m-d H:i:s') . '</p>
    
    <table border="1" cellpadding="5">
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Package</th>
            <th>Department</th>
            <th>Status</th>
        </tr>';
    
    while($client = $clients->fetch_assoc()) {
        $html .= '
        <tr>
            <td>' . $client['id'] . '</td>
            <td>' . htmlspecialchars($client['name']) . '</td>
            <td>' . htmlspecialchars($client['phone']) . '</td>
            <td>' . $client['package'] . '</td>
            <td>' . $client['current_department'] . '</td>
            <td>' . $client['status'] . '</td>
        </tr>';
    }
    
    $html .= '</table>';
    
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Output('client_report_' . date('Y-m-d') . '.pdf', 'D');
    
} else {
    // CSV export
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="client_report_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    fputcsv($output, ['ID', 'Name', 'Phone', 'Package', 'Country', 'Department', 'Status', 'Payment', 'Created Date']);
    
    // Add data
    while($client = $clients->fetch_assoc()) {
        fputcsv($output, [
            $client['id'],
            $client['name'],
            $client['phone'],
            $client['package'],
            $client['country'],
            $client['current_department'],
            $client['status'],
            $client['payment_status'],
            $client['created_date']
        ]);
    }
    
    fclose($output);
}
?>