<?php
require_once 'config.php';
requireDepartment(['upfollow', 'admin']);

// Get all clients for upscale department
$clients = $conn->query("SELECT * FROM clients WHERE current_department = 'upfollow' OR status = 'completed' ORDER BY updated_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upscale Department | Client Management System</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="main-content">
        <h1><i class="fas fa-chart-bar"></i> Upscale Department</h1>
        
        <div class="dashboard-cards">
            <div class="card">
                <h3>Total Upscale Clients</h3>
                <div class="count"><?php echo $clients->num_rows; ?></div>
            </div>
            <?php 
            $completed = $conn->query("SELECT COUNT(*) as count FROM clients WHERE status = 'completed'")->fetch_assoc()['count'];
            $paid = $conn->query("SELECT COUNT(*) as count FROM clients WHERE payment_status = 'collected'")->fetch_assoc()['count'];
            ?>
            <div class="card">
                <h3>Completed Projects</h3>
                <div class="count"><?php echo $completed; ?></div>
            </div>
            <div class="card">
                <h3>Paid Projects</h3>
                <div class="count"><?php echo $paid; ?></div>
            </div>
        </div>
        
        <div class="table-container">
            <h2><i class="fas fa-users"></i> All Clients & Projects</h2>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Package</th>
                        <th>Department</th>
                        <th>Status</th>
                        <th>Payment</th>
                        <th>History</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($client = $clients->fetch_assoc()): 
                        // Get client history
                        $history = $conn->query("SELECT * FROM client_history WHERE client_id = {$client['id']} ORDER BY action_date DESC LIMIT 3");
                    ?>
                    <tr>
                        <td>#<?php echo str_pad($client['id'], 5, '0', STR_PAD_LEFT); ?></td>
                        <td><?php echo htmlspecialchars($client['name']); ?></td>
                        <td><?php echo htmlspecialchars($client['phone']); ?></td>
                        <td>
                            <span class="status-badge <?php echo $client['package'] === 'paid' ? 'status-completed' : 'status-pending'; ?>">
                                <?php echo ucfirst($client['package']); ?>
                            </span>
                        </td>
                        <td><?php echo ucfirst($client['current_department']); ?></td>
                        <td>
                            <span class="status-badge status-<?php echo str_replace('_', '-', $client['status']); ?>">
                                <?php echo ucwords(str_replace('_', ' ', $client['status'])); ?>
                            </span>
                        </td>
                        <td>
                            <span class="status-badge <?php echo $client['payment_status'] === 'collected' ? 'status-completed' : 'status-pending'; ?>">
                                <?php echo ucfirst($client['payment_status']); ?>
                            </span>
                        </td>
                        <td>
                            <button class="btn btn-info btn-sm" onclick="showHistory(<?php echo $client['id']; ?>)">
                                <i class="fas fa-history"></i> View History
                            </button>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- History Modal -->
    <div class="modal" id="historyModal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Client History</h3>
                <button class="btn-close" onclick="closeHistoryModal()">&times;</button>
            </div>
            <div id="historyContent">
                Loading history...
            </div>
        </div>
    </div>

    <script>
        function showHistory(clientId) {
            fetch(`api/get_client_history.php?id=${clientId}`)
                .then(response => response.json())
                .then(data => {
                    const modal = document.getElementById('historyModal');
                    const content = document.getElementById('historyContent');
                    
                    let html = '<div class="history-list">';
                    data.forEach(record => {
                        html += `
                            <div class="history-item">
                                <p><strong>${record.action_date}</strong></p>
                                <p>${record.from_department} → ${record.to_department}</p>
                                <p>${record.notes}</p>
                                <hr>
                            </div>
                        `;
                    });
                    html += '</div>';
                    
                    content.innerHTML = html;
                    modal.classList.add('active');
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Failed to load history');
                });
        }
        
        function closeHistoryModal() {
            document.getElementById('historyModal').classList.remove('active');
        }
    </script>

    <?php include 'footer.php'; ?>
</body>
</html>