<?php
session_start();
require_once 'config.php';

// Only allow registration if not in production
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register'])) {
    $username = $conn->real_escape_string($_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $full_name = $conn->real_escape_string($_POST['full_name']);
    $email = $conn->real_escape_string($_POST['email']);
    $department = $conn->real_escape_string($_POST['department']);
    
    $stmt = $conn->prepare("INSERT INTO users (username, password, full_name, email, department) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $username, $password, $full_name, $email, $department);
    
    if ($stmt->execute()) {
        $message = "User registered successfully!";
    } else {
        $error = "Error: " . $conn->error;
    }
    
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register User</title>
</head>
<body>
    <h2>Register New User</h2>
    <?php if (isset($message)) echo "<p style='color:green;'>$message</p>"; ?>
    <?php if (isset($error)) echo "<p style='color:red;'>$error</p>"; ?>
    
    <form method="POST">
        <input type="text" name="username" placeholder="Username" required><br><br>
        <input type="password" name="password" placeholder="Password" required><br><br>
        <input type="text" name="full_name" placeholder="Full Name" required><br><br>
        <input type="email" name="email" placeholder="Email" required><br><br>
        <select name="department" required>
            <option value="">Select Department</option>
            <option value="admin">Admin</option>
            <option value="lead">Lead</option>
            <option value="sales">Sales</option>
            <option value="delivery">Delivery</option>
            <option value="project">Project</option>
            <option value="upfollow">Upscale</option>
        </select><br><br>
        <button type="submit" name="register">Register</button>
    </form>
</body>
</html>