<?php
require_once 'config.php';
requireDepartment(['delivery', 'admin']);

// Handle department transfers
if (isset($_GET['transfer'])) {
    $client_id = intval($_GET['client_id']);
    $to_department = $conn->real_escape_string($_GET['to']);
    
    // Get current department
    $current_stmt = $conn->prepare("SELECT current_department FROM clients WHERE id = ?");
    $current_stmt->bind_param("i", $client_id);
    $current_stmt->execute();
    $result = $current_stmt->get_result();
    $client = $result->fetch_assoc();
    $from_department = $client['current_department'];
    
    // Update client
    $update_stmt = $conn->prepare("UPDATE clients SET current_department = ?, updated_at = NOW() WHERE id = ?");
    $update_stmt->bind_param("si", $to_department, $client_id);
    $update_stmt->execute();
    
    // Log the action
    $action_stmt = $conn->prepare("INSERT INTO client_history (client_id, from_department, to_department, action_by, notes) VALUES (?, ?, ?, ?, ?)");
    $notes = "Transferred from " . ucfirst($from_department) . " to " . ucfirst($to_department) . " department";
    $action_stmt->bind_param("isssi", $client_id, $from_department, $to_department, $_SESSION['user_id'], $notes);
    $action_stmt->execute();
    
    header('Location: delivery_dept.php?success=1');
    exit();
}

// Get clients in delivery department
$clients = $conn->query("SELECT * FROM clients WHERE current_department = 'delivery' ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delivery Department | Client Management System</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="main-content">
        <h1><i class="fas fa-shipping-fast"></i> Delivery Department</h1>
        
        <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success">
            Client transferred successfully!
        </div>
        <?php endif; ?>
        
        <div class="table-container">
            <h2><i class="fas fa-users"></i> Clients in Delivery Department</h2>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Package</th>
                        <th>Country</th>
                        <th>Note</th>
                        <th>Created</th>
                        <th>Transfer To</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($client = $clients->fetch_assoc()): ?>
                    <tr>
                        <td>#<?php echo str_pad($client['id'], 5, '0', STR_PAD_LEFT); ?></td>
                        <td><?php echo htmlspecialchars($client['name']); ?></td>
                        <td><?php echo htmlspecialchars($client['phone']); ?></td>
                        <td>
                            <span class="status-badge <?php echo $client['package'] === 'paid' ? 'status-completed' : 'status-pending'; ?>">
                                <?php echo ucfirst($client['package']); ?>
                            </span>
                        </td>
                        <td><?php echo htmlspecialchars($client['country']); ?></td>
                        <td><?php echo htmlspecialchars(substr($client['note'] ?? '', 0, 50)); ?>...</td>
                        <td><?php echo date('M d, Y', strtotime($client['created_at'])); ?></td>
                        <td>
                            <div class="btn-group">
                                <a href="?client_id=<?php echo $client['id']; ?>&transfer=1&to=sales" class="btn btn-warning btn-sm" onclick="return confirm('Send back to Sales department?')">
                                    <i class="fas fa-arrow-left"></i> Sales
                                </a>
                                <a href="?client_id=<?php echo $client['id']; ?>&transfer=1&to=project" class="btn btn-success btn-sm" onclick="return confirm('Refer to Project department?')">
                                    <i class="fas fa-arrow-right"></i> Project
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php include 'footer.php'; ?>
</body>
</html>