<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json');

if (isset($_GET['id'])) {
    $client_id = intval($_GET['id']);
    
    $stmt = $conn->prepare("SELECT * FROM clients WHERE id = ?");
    $stmt->bind_param("i", $client_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 1) {
        $client = $result->fetch_assoc();
        echo json_encode($client);
    } else {
        echo json_encode(['error' => 'Client not found']);
    }
    
    $stmt->close();
} else {
    echo json_encode(['error' => 'No client ID provided']);
}
?>